/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorCage {
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final BlockState[][][] blockStates;
    public final VoxelShape shape;
    public final List<AABB> collisionBoxes;
    public final AABB bounds;

    public static ElevatorCage createCageAndClear(Level world, BlockPos startPos, int xSize, int ySize, int zSize) {
        BlockPos pos;
        int z;
        int y;
        int x;
        if (!ElevatorCage.canCreateCage(world, startPos, xSize, ySize, zSize)) {
            return null;
        }
        BlockState[][][] states = new BlockState[xSize][ySize][zSize];
        VoxelShape shape = Shapes.m_83040_();
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.m_142082_(x, y, z);
                    if (world.m_46859_(pos)) continue;
                    states[x][y][z] = world.m_8055_(pos);
                    VoxelShape blockShape = states[x][y][z].m_60812_((BlockGetter)world, pos);
                    blockShape = blockShape.m_83216_((double)x, (double)y, (double)z);
                    shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)blockShape, (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.m_142082_(x, y, z);
                    if (states[x][y][z] == null) continue;
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 20);
                }
            }
        }
        for (x = 0; x < xSize; ++x) {
            for (y = 0; y < ySize; ++y) {
                for (z = 0; z < zSize; ++z) {
                    pos = startPos.m_142082_(x, y, z);
                    if (states[x][y][z] == null) continue;
                    world.markAndNotifyBlock(pos, world.m_46745_(pos), states[x][y][z], world.m_8055_(pos), 3, 512);
                }
            }
        }
        shape.m_83296_();
        return new ElevatorCage(xSize, ySize, zSize, states, shape.m_83299_());
    }

    public static boolean canCreateCage(Level world, BlockPos startPos, int xSize, int ySize, int zSize) {
        boolean hasBlocks = false;
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    if (world.m_46859_(startPos.m_142082_(x, y, z))) continue;
                    if (!ElevatorCage.canBlockBeInCage(world, startPos.m_142082_(x, y, z))) {
                        return false;
                    }
                    hasBlocks = true;
                }
            }
        }
        return hasBlocks;
    }

    public static boolean canBlockBeInCage(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60819_().m_76178_() && state.m_60800_((BlockGetter)world, pos) >= 0.0f && !(state.m_60734_() instanceof EntityBlock);
    }

    public ElevatorCage(int xSize, int ySize, int zSize, BlockState[][][] states, List<AABB> collisionBoxes) {
        if (states.length != xSize || states[0].length != ySize || states[0][0].length != zSize) {
            throw new IllegalArgumentException("Given size and block state array do not match!");
        }
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.blockStates = states;
        this.collisionBoxes = Collections.unmodifiableList(collisionBoxes);
        VoxelShape shape = Shapes.m_83040_();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (AABB box : collisionBoxes) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82695_);
            minX = Math.min(minX, box.f_82288_);
            minY = Math.min(minY, box.f_82289_);
            minZ = Math.min(minZ, box.f_82290_);
            maxX = Math.max(maxX, box.f_82291_);
            maxY = Math.max(maxY, box.f_82292_);
            maxZ = Math.max(maxZ, box.f_82293_);
        }
        this.shape = shape.m_83296_();
        this.bounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void place(Level world, BlockPos startPos) {
        int z;
        int y;
        int x;
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState state = this.blockStates[x][y][z];
                    if (state == null) continue;
                    BlockPos pos = startPos.m_142082_(x, y, z);
                    if (world.m_46859_(pos)) {
                        world.m_46597_(pos, state);
                        continue;
                    }
                    if (world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f) {
                        world.m_46961_(pos, true);
                        world.m_46597_(pos, state);
                        continue;
                    }
                    Containers.m_18992_((Level)world, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (ItemStack)new ItemStack((ItemLike)state.m_60734_()));
                }
            }
        }
        for (x = 0; x < this.xSize; ++x) {
            for (y = 0; y < this.ySize; ++y) {
                for (z = 0; z < this.zSize; ++z) {
                    BlockState updatedState;
                    BlockPos neighbor;
                    Direction direction;
                    BlockPos pos = startPos.m_142082_(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    if (x == 0) {
                        direction = Direction.WEST;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (x == this.xSize - 1) {
                        direction = Direction.EAST;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (y == 0) {
                        direction = Direction.DOWN;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (y == this.ySize - 1) {
                        direction = Direction.UP;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (z == 0) {
                        direction = Direction.NORTH;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (z == this.zSize - 1) {
                        direction = Direction.SOUTH;
                        neighbor = pos.m_142300_(direction);
                        updatedState = state.m_60728_(direction, world.m_8055_(neighbor), (LevelAccessor)world, pos, neighbor);
                        Block.m_49908_((BlockState)state, (BlockState)updatedState, (LevelAccessor)world, (BlockPos)pos, (int)3, (int)512);
                    }
                    if (!world.f_46443_ && state.m_60734_() instanceof ButtonBlock && state.m_61138_((Property)ButtonBlock.f_51045_) && ((Boolean)state.m_61143_((Property)ButtonBlock.f_51045_)).booleanValue()) {
                        state.m_60616_((ServerLevel)world, pos, world.f_46441_);
                    }
                    if (world.f_46443_ || !(state.m_60734_() instanceof PressurePlateBlock) || !state.m_61138_((Property)PressurePlateBlock.f_55249_) || !((Boolean)state.m_61143_((Property)PressurePlateBlock.f_55249_)).booleanValue()) continue;
                    state.m_60616_((ServerLevel)world, pos, world.f_46441_);
                }
            }
        }
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("xSize", this.xSize);
        compound.m_128405_("ySize", this.ySize);
        compound.m_128405_("zSize", this.zSize);
        int[] stateIds = new int[this.xSize * this.ySize * this.zSize];
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    int index = x * this.ySize * this.zSize + y * this.zSize + z;
                    stateIds[index] = Block.m_49956_((BlockState)this.blockStates[x][y][z]);
                }
            }
        }
        compound.m_128385_("blockStates", stateIds);
        ListTag collisionBoxList = new ListTag();
        this.collisionBoxes.forEach(box -> collisionBoxList.add((Object)ElevatorCage.writeBox(box)));
        compound.m_128365_("collisionBoxes", (Tag)collisionBoxList);
        return compound;
    }

    public static ElevatorCage read(CompoundTag compound) {
        int xSize = compound.m_128451_("xSize");
        int ySize = compound.m_128451_("ySize");
        int zSize = compound.m_128451_("zSize");
        int[] stateIds = compound.m_128465_("blockStates");
        BlockState[][][] blockStates = new BlockState[xSize][ySize][zSize];
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                for (int z = 0; z < zSize; ++z) {
                    int index = x * ySize * zSize + y * zSize + z;
                    BlockState state = Block.m_49803_((int)stateIds[index]);
                    blockStates[x][y][z] = state.m_60734_() == Blocks.f_50016_ ? null : state;
                }
            }
        }
        ListTag collisionBoxList = compound.m_128437_("collisionBoxes", 10);
        List<AABB> collisionBoxes = collisionBoxList.stream().map(CompoundTag.class::cast).map(ElevatorCage::readBox).collect(Collectors.toList());
        return new ElevatorCage(xSize, ySize, zSize, blockStates, collisionBoxes);
    }

    private static CompoundTag writeBox(AABB box) {
        CompoundTag compound = new CompoundTag();
        compound.m_128347_("x1", box.f_82288_);
        compound.m_128347_("y1", box.f_82289_);
        compound.m_128347_("z1", box.f_82290_);
        compound.m_128347_("x2", box.f_82291_);
        compound.m_128347_("y2", box.f_82292_);
        compound.m_128347_("z2", box.f_82293_);
        return compound;
    }

    private static AABB readBox(CompoundTag compound) {
        return new AABB(compound.m_128459_("x1"), compound.m_128459_("y1"), compound.m_128459_("z1"), compound.m_128459_("x2"), compound.m_128459_("y2"), compound.m_128459_("z2"));
    }
}

